package gov.va.med.mhv.sm.web.session;

import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Patient;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Represents items that are stored in the session for 
 * the patient blocking workflow.  I have tried not to
 * muddy up the session with various random items but
 * instead opted to store them in a session object that
 * can be created and cleared easily
 * 
 * @author PII
 *
 */
public class BlockPatientSession {

	private Collection<Patient> patients;
	private Patient selectedPatient;
	private Facility selectedVisn;
	private Collection<Facility> facilities;
	private Facility selectedFacility;
	private String formattedZipCode;
	
	public BlockPatientSession(){
		patients = new ArrayList<Patient>();
		facilities = new ArrayList<Facility>();
		selectedPatient = null;
		selectedVisn = null;
	}
	
	private Collection<Facility> visns = null;
	
	public Collection<Patient> getPatients() {
		return patients;
	}
	public void setPatients(Collection<Patient> patients) {
		this.patients = patients;
	}
	public Patient getSelectedPatient() {
		return selectedPatient;
	}
	public void setSelectedPatient(Patient selectedPatient) {
		this.selectedPatient = selectedPatient;
	}
	public Facility getSelectedVisn() {
		return selectedVisn;
	}
	public void setSelectedVisn(Facility selectedVisn) {
		this.selectedVisn = selectedVisn;
	}
	public Collection<Facility> getFacilities() {
		return facilities;
	}
	public void setFacilities(Collection<Facility> facilities) {
		this.facilities = facilities;
	}
	public Facility getSelectedFacility() {
		return selectedFacility;
	}
	public void setSelectedFacility(Facility selectedFacility) {
		this.selectedFacility = selectedFacility;
	}


	public String getFormattedZipCode() {
		return formattedZipCode;
	}


	public void setFormattedZipCode(String formattedZipCode) {
		this.formattedZipCode = formattedZipCode;
	}
	public Collection<Facility> getVisns() {
		return visns;
	}
	public void setVisns(Collection<Facility> visns) {
		this.visns = visns;
	}
	
}
